//
//  MCSyncWorker.h
//  GWSyncServices
//
//  Created by Michael Clark on 20/12/06.
//  Copyright 2006 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCSyncManager.h"
#import "MCSyncWorkerProtocol.h"
#import "MCSyncManagerProtocol.h"

// Dictionary keys used to pass parameters to the class method which setups the SyncWorker for the SyncManager
extern NSString*     MCSyncWorkerParameterPortArrayKey;
extern NSString*     MCSyncWorkerParameterApplicationSyncConfigPathKey;
extern NSString*     MCSyncWorkerParameterDatabaseInfoKey;
extern NSString*     MCSyncWorkerParameterDatabaseConnectionInfoKey;
extern NSString*     MCSyncWorkerClientIdentifierKey;
extern NSString*     MCSyncWorkClientSyncIdentifierKey;

// Used to generate date-time stamp for the log file name
extern NSString*    MCSyncWorkerLogFileCalendarFormat;

@class MCSyncConfig;
@class MCPObjectContext;
@class MCFileLogger;
@class ISyncSession,ISyncClient;

#define USE_OOM 0

@interface MCSyncWorker : NSObject <MCSyncWorkerProtocol> {

	@protected
	
	NSString*                        __clientIdentifier;
	NSString*                        __clientSyncIdentifier;
	NSDictionary*                    __dbInfo;
	MCPObjectContext*                __localObjectContext;
	
	BOOL                             __isCurrentSyncBlocking;
	ISyncSession*                    __activeSyncSession;
	
	NSMutableDictionary*             __entityGroupProcessors;
	
	id <MCSyncManagerProtocol>       __syncManagerProxy;
	MCSyncConfig*                    __syncConfig;
	
	MCFileLogger*                    __logger;
	
	BOOL                             __continueSyncing;
}

+ (void)configureSyncWorkerWithParameterDictionary: (NSDictionary*)params_dict;

- (id)initWithDatabaseConnectionInfo: (NSDictionary*)dbInfo clientIdentifier: (NSString*)clientIdentifier 
				clientSyncIdentifier: (NSString*)clientSyncIdentifier applicationSyncConfigFilePath: (NSString*)configPath;

- (NSString*)logFileLocation;
	// Can be overriden by subclasses to put the logfiles somewhere special - the default implementation puts them in /tmp

- (void)cleanUpAfterSync: (BOOL)wasSuccessful exceptionReason: (NSString*)exceptionReason;
	// Subclassers can override this to do additional clean up between syncs
	// Default behaviour is to destroy all the entityGroupProcessors and the logger

#pragma mark Accessors
- (void)setSyncManagerProxy: (id <MCSyncManagerProtocol>)proxy;

@end

